#include <p30fxxxx.h>
#include <timer.h>

/* These devices support Timers 4 and 5 */
#if defined(__dsPIC30F3010__) || defined(__dsPIC30F4012__) || defined(__dsPIC30F3011__)  || \
    defined(__dsPIC30F4011__) || defined(__dsPIC30F6010__) || defined(__dsPIC30F5011__) || \
    defined(__dsPIC30F6011__) || defined(__dsPIC30F6012__) || defined(__dsPIC30F5013__) || \
    defined(__dsPIC30F6013__) || defined(__dsPIC30F6014__) || defined(__dsPIC30F4013__) || \
    defined(__dsPIC30F5015__)

/********************************************************************
*    Function Name:  CloseTimer45                                   *
*    Description:    This routine disables the Timer4 and 5 and its *
*                    interrupt and flag bits                        *
*    Parameters:     None                                           *
*    Return Value:   None                                           *
********************************************************************/

void CloseTimer45(void)
{
    IEC1bits.T5IE = 0;      /* Disable the Timer5 interrupt */
    if (T4CONbits.T32 == 1)
        T4CONbits.TON = 0;  /* Disable Timer 4 */
    IFS1bits.T5IF = 0;      /* Clear Timer5 interrupt flag */
}

#endif 
